// elabtestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "elabtest.h"
#include "elabtestDlg.h"
#include <iostream>		// for writing data to .txt files
using std::cerr;
using std::endl;

#include <fstream>
using std::ofstream;
#include <cstdlib>		// for exit function


#include <math.h>		// for sine function

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////Global Variables and type definitions//////////////////
	int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow);

	HINSTANCE hDLL;							// Handle to DLL

	typedef bool (*GETHWSTATUS)();
	GETHWSTATUS GetHWStatus;				// Function pointer
	
	typedef long (*AWGSTART)(long);
	AWGSTART AWGStart;						// Function pointer

	typedef long (*AWGSTOP)();
	AWGSTOP AWGStop;						// Function pointer

	typedef long (*SETUPAWG)(double *, short *, long, double, double, long, double, long, long, long);
	SETUPAWG SetupAWG;						//function pointer

	typedef bool (*GETSERIALNUMBER)(long *);
	GETSERIALNUMBER GetSerialNumber;		// Function pointer

	typedef double (*SETPROGCLOCKS)(char, double, double, double *, double *, long);
	SETPROGCLOCKS SetProgClocks;			// Function Pointer

	typedef float (*SETUPPS)(float);
	SETUPPS SetUPPS1, SetUPPS2;				// Function pointers

	typedef double (*SETDSOLASAMPLERATE)(double);
	SETDSOLASAMPLERATE SetDSOLASampleRate;

	//typedef int (*CAPTUREDSODATA)(unsigned int, unsigned int, unsigned int, double, unsigned int, long);
	//CAPTUREDSODATA CaptureDSOData;

	typedef int (*CAPTUREDSODATA)(unsigned int total_blocks, unsigned int pre_trigger_blocks, unsigned int trigger_channel, double trigger_value, unsigned int LA_trigger, unsigned int auto_roll, long OverrideOtherClocks);
	CAPTUREDSODATA CaptureDSOData;

	typedef long (*RETRIEVEDSODATA)(unsigned char, double *, double *, unsigned short *, unsigned char);
	RETRIEVEDSODATA RetrieveDSOData;

	typedef bool (*POLLDSOREADY)();
	POLLDSOREADY PollDSOReady;


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElabtestDlg dialog

CElabtestDlg::CElabtestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CElabtestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CElabtestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CElabtestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CElabtestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CElabtestDlg, CDialog)
	//{{AFX_MSG_MAP(CElabtestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDCHECKSTATUS, OnCheckstatus)
	ON_BN_CLICKED(IDC_GetSerialNum, OnGetSerialNum)
	ON_BN_CLICKED(IDC_AWGStart, OnAWGStart)
	ON_BN_CLICKED(IDC_AWGStop, OnAWGStop)
	ON_BN_CLICKED(IDC_SetUPPS1, OnSetUPPS1)
	ON_BN_CLICKED(IDC_SetUPPS2, OnSetUPPS2)
	ON_BN_CLICKED(IDC_SetupAWG, OnSetupAWG)
	ON_BN_CLICKED(IDC_SetProgClocks, OnSetProgClocks)
	ON_BN_CLICKED(IDC_CaptureDSOData, OnCaptureDSOData)
	ON_BN_CLICKED(IDC_RetrieveDSOData, OnRetrieveDSOData)
	ON_BN_CLICKED(IDC_WriteFile, OnWriteFile)
	ON_BN_CLICKED(IDC_SetDSOLASampleRate, OnSetDSOLASampleRate)
	ON_BN_CLICKED(IDC_PollDSOReady, OnPollDSOReady)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElabtestDlg message handlers

BOOL CElabtestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	hDLL = LoadLibrary("ElabDLL.dll");	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CElabtestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CElabtestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CElabtestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CElabtestDlg::OnCheckstatus() 
{

	DWORD dwParam1=0;
	bool uReturnVal=0;
	if (hDLL != NULL)
	{
		GetHWStatus = (GETHWSTATUS)GetProcAddress(hDLL,"GetHWStatus");

		if (!GetHWStatus)
		{
			MessageBox("Can't find the function");     
		}
		else
		{
			// call the function
			uReturnVal = GetHWStatus();
		}

		if (uReturnVal == FALSE) {
			MessageBox("Can't find the ELAB-080");
		}

		if (uReturnVal == TRUE) {
			MessageBox("ELAB-080 is attached and ready");
		}
	}
}

void CElabtestDlg::OnGetSerialNum() 
{
	bool uReturnVal;
	long *SerialNumberPtr;
	long SerialNumber=0;

	char buffer [sizeof(long)*8+1];

	SerialNumberPtr = &SerialNumber;

	if (hDLL == NULL) {
		MessageBox("hello");
	}

	if (hDLL != NULL)
	{
		GetSerialNumber = (GETSERIALNUMBER)GetProcAddress(hDLL,"GetSerialNumber");

		if (!GetSerialNumber)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = GetSerialNumber(SerialNumberPtr);
		}

		if (uReturnVal == FALSE) {
			MessageBox("Problem, is the ELAB connected?");
		}

		if (uReturnVal == TRUE) {
			ltoa (SerialNumber,buffer,10);
			MessageBox(buffer, "ELAB Serial Number");
		}
	}
}

void CElabtestDlg::OnAWGStart() 
{
	long uReturnVal;
	long OverrideOtherClocks=1;
	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		AWGStart = (AWGSTART)GetProcAddress(hDLL,"AWGStart");

		if (!AWGStart)
		{
			MessageBox("Can't find the function");     
		}
		else
		{
			// call the function
			uReturnVal = AWGStart(OverrideOtherClocks);
		}

		ltoa (uReturnVal,buffer,10);
		//MessageBox(buffer, "ELAB return code");
		
	}	
}

void CElabtestDlg::OnAWGStop() 
{	
	long uReturnVal;
	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		AWGStop = (AWGSTOP)GetProcAddress(hDLL,"AWGStop");

		if (!AWGStop)
		{
			MessageBox("Can't find the function");     
		}
		else
		{
			// call the function
			uReturnVal = AWGStop();
		}

		ltoa (uReturnVal,buffer,10);
//		MessageBox(buffer, "ELAB return code");
		
	}	
}

void CElabtestDlg::OnSetUPPS1() 
{
	float uReturnVal;
	float Voltage=9;

	char buffer [sizeof(long)*8+1];

	Sleep(100);	// give the system time to load the DLL
	if (hDLL != NULL)
	{
		SetUPPS1 = (SETUPPS)GetProcAddress(hDLL,"SetUPPS1");

		if (!SetUPPS1)
		{
			MessageBox("Can't find the function");       
		}
		else
		{
			// call the function
			uReturnVal = SetUPPS1(Voltage);
		}

		ltoa ((long)uReturnVal,buffer,10);
//		MessageBox(buffer, "ELAB return code");
	}
}



void CElabtestDlg::OnSetUPPS2() 
{	
	float uReturnVal;
	float Voltage=3;
	char buffer [sizeof(long)*8+1];

	Sleep(100);	// give the system time to load the DLL
	if (hDLL != NULL)
	{
		SetUPPS2 = (SETUPPS)GetProcAddress(hDLL,"SetUPPS2");

		if (!SetUPPS2)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = SetUPPS2(Voltage);
		}

		ltoa ((long)uReturnVal,buffer,10);
//		MessageBox(buffer, "ELAB return code");	
	}	
}

void CElabtestDlg::OnSetupAWG() 
{

	long uReturnVal;

	double AnalogVoltage[4096];
	double *AnalogVoltagePtr=&AnalogVoltage[0];

	short DigitalData[4096];
	short *DigitalDataPtr=&DigitalData[0];

	long BufferSize=1000;
	double DCOffsetVoltage=0;
	double SampleFrequency=1000*100000;
	long Use4xGain=0;
	double OutputImpedance=50;
	long Repeat=1;
	long Triggered=0;
	long OverrideOtherClocks=1;

	long x=0;			// Loop counter

	// Populate the AnalogVoltage array
	for(x=0;x<=BufferSize-1;x++)
		AnalogVoltage[x]=(0.5)*sin(((double)x/(double)BufferSize)*(2*3.1415));

	// Populate the DigitalData array
	for(x=0;x<=BufferSize-1;x++)
		DigitalData[x]=0;



	char buffer [sizeof(long)*8+1];		// Holds the return code after ltoa() is called

	Sleep(100);	// give the system time to load the DLL
	if (hDLL != NULL)
	{
		SetupAWG = (SETUPAWG)GetProcAddress(hDLL,"SetupAWG");

		if (!SetupAWG)
		{
			MessageBox("Can't find the function");     
		}
		else
		{
			// call the function
			uReturnVal = SetupAWG(AnalogVoltagePtr, DigitalDataPtr, BufferSize, DCOffsetVoltage, SampleFrequency, Use4xGain, OutputImpedance, Repeat, Triggered, OverrideOtherClocks);
			Sleep(100);
		}

		ltoa(uReturnVal,buffer,10);
		//MessageBox(buffer, "ELAB Return Code");	
	}
}

void CElabtestDlg::OnSetProgClocks() 
{
	double uReturnVal;
	char Switch=1;
	double Frequency1=10000;
	double Frequency2=10000;
	double Freq1Actual;
	double *Freq1ActualPtr=&Freq1Actual;
	double Freq2Actual;
	double *Freq2ActualPtr=&Freq2Actual;
	long OverrideClocks=1;
	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		SetProgClocks = (SETPROGCLOCKS)GetProcAddress(hDLL,"SetProgClocks");

		if (!SetProgClocks)
		{
			MessageBox("Can't find the function");     
		}
		else
		{
			// call the function
			uReturnVal = SetProgClocks(Switch, Frequency1, Frequency2, Freq1ActualPtr, Freq2ActualPtr, OverrideClocks);
		}

		ltoa ((long)Freq1Actual,buffer,10);
		//MessageBox(buffer, "ELAB Return Code");
		
	}	
	
}

void CElabtestDlg::OnCancel() 
{
	FreeLibrary(hDLL); 	
	CDialog::OnCancel();
}


void CElabtestDlg::OnCaptureDSOData() 
{
	int uReturnVal;
	unsigned int total_blocks=8;
	unsigned int pre_trigger_blocks=0;
	unsigned int trigger_channel=0;
	double trigger_value=.25;
	unsigned int auto_roll=0;
	unsigned int LA_trigger=0;
	long OverrideOtherClocks=1;

	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		CaptureDSOData = (CAPTUREDSODATA)GetProcAddress(hDLL,"CaptureDSOData");

		if (!CaptureDSOData)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = CaptureDSOData(total_blocks, pre_trigger_blocks, trigger_channel, LA_trigger, trigger_value, auto_roll, OverrideOtherClocks);
		}

		ltoa ((long)uReturnVal,buffer,10);
//		MessageBox(buffer, "ELAB return code");	
	}
}

void CElabtestDlg::OnRetrieveDSOData() 
{
	int i;
	long uReturnVal;
	unsigned char whatchannels=3;

	double DSOCH1[8192];
	double *DSOCH1ptr=&DSOCH1[0];

	double DSOCH2[8192];
	double *DSOCH2ptr=&DSOCH2[0];

	unsigned short LADATA[4096];
	unsigned short *LADATAptr=&LADATA[0];

	unsigned char Nth_Sample=1;

	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		RetrieveDSOData = (RETRIEVEDSODATA)GetProcAddress(hDLL,"RetrieveDSOData");

		if (!RetrieveDSOData)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = RetrieveDSOData(whatchannels, DSOCH1ptr, DSOCH2ptr, LADATAptr, Nth_Sample);
		}

		ltoa ((long)uReturnVal,buffer,10);
		MessageBox(buffer, "ELAB return code");	

		ofstream outdata; // outdata is like cin

		outdata.open("c:\\output.txt"); // opens the file
		if( !outdata ) { // file couldn't be opened
			cerr << "Error: file could not be opened" << endl;
			exit(1);
		}

		for (i=0; i<uReturnVal; ++i)
			outdata << DSOCH1[i] << endl;
		outdata.close();				// closes the file
	}
}

void CElabtestDlg::OnWriteFile() 
{
   ofstream outdata; // outdata is like cin
   int i; // loop index
   int num[5] = {4, 3, 6, 7, 12}; // list of output values

   outdata.open("c:\\output.txt"); // opens the file
   if( !outdata ) { // file couldn't be opened
      cerr << "Error: file could not be opened" << endl;
      exit(1);
   }

   for (i=0; i<5; ++i)
      outdata << num[i] << endl;
   outdata.close();

//   return 0;	
}

void CElabtestDlg::OnSetDSOLASampleRate() 
{
	double uReturnVal;
	double DesiredFreq=50000000;

	char buffer [sizeof(long)*8+1];

	if (hDLL != NULL)
	{
		SetDSOLASampleRate = (SETDSOLASAMPLERATE)GetProcAddress(hDLL,"SetDSOLASampleRate");

		if (!SetDSOLASampleRate)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = SetDSOLASampleRate(DesiredFreq);
		}

		ltoa ((long)uReturnVal,buffer,10);
//		MessageBox(buffer, "ELAB return code");	
	}	
}

void CElabtestDlg::OnPollDSOReady() 
{
	bool uReturnVal;

	if (hDLL != NULL)
	{
		PollDSOReady = (POLLDSOREADY)GetProcAddress(hDLL, "PollDSOReady");

		if (!PollDSOReady)
		{
			MessageBox("Can't find the function");      
		}
		else
		{
			// call the function
			uReturnVal = PollDSOReady();
		}

		if (uReturnVal == true)
		{
			MessageBox("Ready", "ELAB return code");	
		}
		else
		{
			MessageBox("NOT Ready", "ELAB return code");
		}
	}

}
